#version 3
#include "colors.inc"
#include "cuerpo.inc"

background { SkyBlue }

plane { y, -.0999
        pigment { LimeGreen }
        normal { spotted 1 } //scale <3, 2, .2> } //rotate 90*x  }
	finish { phong .4 phong_size 2 }
}

//*********************begin the outer world

#include "casucha.inc"

object { Casucha no_shadow }
object { Techo no_shadow }
                                                
//----------------walls

#declare Empalizada = box { <-15, -.50, -15>, <-14, 4, 20> rotate .2*z }  //lateral derecho

object { Empalizada 
        pigment { color rgb <0.753,0.408,0.384> }
        normal { wrinkles .4 }
	finish { phong .1 phong_size 1 }
}


//----------------sun
/* place where the sun can be viewed???
#declare VentanaC = box { //lateral window
        <-2, -2, -1>,
        < 2,  1,  1>
        rotate -90*y
        translate <0, 4, 4>
*/

#include "sol.inc"
#declare ocaso = union { object { Sol rotate -90*y translate <-20, 9, 4> }
                         light_source { 0*x  color rgb 1 translate <-20, 8, 7> }
}


object { ocaso
        #declare clock_type = "accellerate"
        //#declare clock_repeat = 5 ;
        #include "clockmod.inc"
                
        translate -.58 * y * mclock * 10 //rotate left arm

}



//*********************end the outter world

#declare Bodimov = union {
                        object { PieIzq 
                                pigment { color Med_Purple }
                                translate <0, 2.5, 0>
                        }
                        object { PieDer
                                pigment { color Med_Purple }
                                translate <0, 2.5, 0>
                        }
                        object { Torso
                                pigment { color Very_Light_Purple }
                                translate 2.2*y
                        }
                        object { BrazoIzq
                                pigment { color Med_Purple }
                                translate <.3, 3, 0>
                        }
                        object { BrazoDer pigment
                                { color Med_Purple }
                                translate <-.3, 3, 0>
                        }
                        object { Cabeza
                                translate 3.15*y
                                pigment { color Cyan } //rgb <0.753,0.000,0.753>+.5 }
                        }
}


object { Bodimov
        rotate 90*y
        translate <3, 0, 4>
        
}
        
//***********************mesa 

#declare pata = box { <.2, 0, 1>, <.3, 1.8, 1.3> } 
#declare patas = union {
                        object { pata }
                        object { pata translate <2.2, 0, 0> }
                        object { pata translate <2.2, 0, 3.6> }
                        object { pata translate <0, 0, 3.6> }
}
#declare tabla = box { <0, 1.7, .8>, <2.6, 1.81, 5> }
#declare mesa = union {
                        object { patas }
                        object { tabla }
                        pigment { color Red } 
                        translate 1.2*z
}
object { mesa }

#declare libro = box { <1, 1.81, 2.5>, <2, 1.9, 3.1> pigment { color White } }
object { libro }

#declare pizarra = box { <0,0,0>, <4, 3, .1> pigment { image_map { gif "piza.gif" } scale <4, 3, 1> } }
object { pizarra translate <2.5, 3, 9.3> }


#declare Camarita = camera {
                        location  <6, 3.5,  5>
                        look_at   <0, 3.4,  6>
}


#declare luz = light_source { 0*x  color rgb 1 translate <  6,  7, 5> }

object { luz
        #declare clock_type = "accellerate"
        //#declare clock_repeat = 5 ;
        #include "clockmod.inc"
                
        color rgb -.05 * mclock * 10 //rotate left arm

}





camera { Camarita }
